const router = require("express").Router();
const Form = require("../models/Form");

// create form
router.post("/", async (req, res) => {
    try {
        const form = await Form.create(req.body);
        res.status(201).json(form);
    } catch (err) {
        res.status(500).json({ message: err.message });
    }
});

// Get all forms
router.get("/", async (req, res) => {
    try {
        const forms = await Form.find();
        res.status(200).json(forms);
    } catch (err) {
        res.status(500).json({ message: err.message });
    }
});

// Get single form
router.get("/:id", async (req, res) => {
    try {
        const form = await Form.findById(req.params.id);
        res.status(200).json(form);
    } catch (err) {
        res.status(500).json({ message: err.message });
    }
});

// Update form
router.put("/:id", async (req, res) => {
    try {
        const form = await Form.findByIdAndUpdate(req.params.id, req.body, { new: true });
        res.status(200).json(form);
    } catch (err) {
        res.status(500).json({ message: err.message });
    }
});

// Delete form
router.delete("/:id", async (req, res) => {
    try {
        const form = await Form.findByIdAndDelete(req.params.id);
        res.status(200).json(form);
    } catch (err) {
        res.status(500).json({ message: err.message });
    }
});

module.exports = router;